/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_peek.c,v 1.9 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <pthread.h>
#include <errno.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t
mx_peek(mx_endpoint_t endpoint,
        uint32_t timeout,
        mx_request_t *request,
	uint32_t *result)
{
    struct mx_endpoint *pp;
    struct mx_post *post;
    
    pthread_mutex_lock(&Mx_po_lock);
    
    pp = (struct mx_endpoint *)endpoint;

    if (pp->completed_posts.next == &pp->completed_posts) {
        /* modified by matsuba */
        int rs;
        struct timespec ts;
        struct timeval  tv;

        gettimeofday(&tv, NULL);
        ts.tv_sec = tv.tv_sec + timeout/1000;
        ts.tv_nsec = tv.tv_usec * 1000 + 
            (timeout % 1000) * 1000 * 1000;
        rs = pthread_cond_timedwait(&pp->peek_cond, 
                                    &Mx_po_lock, &ts);
        if (rs == ETIMEDOUT){
            pthread_mutex_unlock(&Mx_po_lock);
	    *result = 0;
            return MX_SUCCESS;
        }
    }
    post = pp->completed_posts.next;
    if (request != NULL) {
        *request = (mx_request_t)post;
	*result = 1;
    }
    else {
      *result = 0;
    }
    pthread_mutex_unlock(&Mx_po_lock);
    MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("end of mx_peek\n"));
    return MX_SUCCESS;
}
